<?php

$conn = new mysqli('localhost', 'gdhhsxmy_mlavallikkunnu', 'mlavallikkunnu', 'gdhhsxmy_mlavallikkunnu');

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

$id = intval($_POST['id'] ?? 0);

// --- UPDATE EXISTING RECORD ---
if ($id > 0) {
    // Update main table
    $stmt = $conn->prepare('
        UPDATE survey_responses 
        SET full_name=?, age=?, gender=?, school_name=?, class_completed=?, stream_interest=?, attended_before=?, parent_accompany=?
        WHERE id=?
    ');
    $stmt->bind_param(
        'sissssssi',
        $_POST['full_name'],
        $_POST['age'],
        $_POST['gender'],
        $_POST['school_name'],
        $_POST['class_completed'],
        $_POST['stream'],
        $_POST['attended'],
        $_POST['parent_accompany'],
        $id
    );
    $stmt->execute();

    // Clear related tables
    $conn->query("DELETE FROM survey_subjects WHERE response_id = $id");
    $conn->query("DELETE FROM survey_careers WHERE response_id = $id");
    $conn->query("DELETE FROM survey_learning WHERE response_id = $id");

    // Reinsert related values
    if (!empty($_POST['subjects'])) {
        $stmtSub = $conn->prepare('INSERT INTO survey_subjects (response_id, subject_name) VALUES (?, ?)');

        foreach ($_POST['subjects'] as $subject) {
            if (!empty($subject)) {
                $stmtSub->bind_param('is', $id, $subject);
                $stmtSub->execute();
            }
        }
    }

    if (!empty($_POST['career'])) {
        $stmtCar = $conn->prepare('INSERT INTO survey_careers (response_id, career_name) VALUES (?, ?)');

        foreach ($_POST['career'] as $career) {
            if (!empty($career)) {
                $stmtCar->bind_param('is', $id, $career);
                $stmtCar->execute();
            }
        }
    }

    if (!empty($_POST['learn'])) {
        $stmtLearn = $conn->prepare('INSERT INTO survey_learning (response_id, learning_item) VALUES (?, ?)');

        foreach ($_POST['learn'] as $item) {
            if (!empty($item)) {
                $stmtLearn->bind_param('is', $id, $item);
                $stmtLearn->execute();
            }
        }
    }

    header('Location: view.php?updated=1');
    exit;
}

// --- INSERT NEW RECORD ---
else {
    $full_name = $_POST['full_name'];

    // 2. Prepare and execute a SELECT statement to check for existing names
    $check_stmt = $conn->prepare('SELECT COUNT(*) FROM survey_responses WHERE full_name = ?');
    $check_stmt->bind_param('s', $full_name);
    $check_stmt->execute();
    $check_stmt->bind_result($count);
    $check_stmt->fetch();
    $check_stmt->close();

    // 3. If a duplicate name is found, handle the error and exit
    if ($count > 0) {
        // You can redirect to an error page or display an error message
        header('Location: savedialog.php?status=duplicate_name');
        exit;
    }



    $stmt = $conn->prepare('
        INSERT INTO survey_responses 
        (full_name, age, gender, school_name, class_completed, stream_interest, attended_before, parent_accompany) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)
    ');
    $stmt->bind_param(
        'sissssss',
        $_POST['full_name'],
        $_POST['age'],
        $_POST['gender'],
        $_POST['school_name'],
        $_POST['class_completed'],
        $_POST['stream'],
        $_POST['attended'],
        $_POST['parent_accompany']
    );
    $stmt->execute();

    $response_id = $conn->insert_id;

    if (!empty($_POST['subjects'])) {
        $stmtSub = $conn->prepare('INSERT INTO survey_subjects (response_id, subject_name) VALUES (?, ?)');

        foreach ($_POST['subjects'] as $subject) {
            if (!empty($subject)) {
                $stmtSub->bind_param('is', $response_id, $subject);
                $stmtSub->execute();
            }
        }
    }

    if (!empty($_POST['career'])) {
        $stmtCar = $conn->prepare('INSERT INTO survey_careers (response_id, career_name) VALUES (?, ?)');

        foreach ($_POST['career'] as $career) {
            if (!empty($career)) {
                $stmtCar->bind_param('is', $response_id, $career);
                $stmtCar->execute();
            }
        }
    }

    if (!empty($_POST['learn'])) {
        $stmtLearn = $conn->prepare('INSERT INTO survey_learning (response_id, learning_item) VALUES (?, ?)');

        foreach ($_POST['learn'] as $item) {
            if (!empty($item)) {
                $stmtLearn->bind_param('is', $response_id, $item);
                $stmtLearn->execute();
            }
        }
    }

    header('Location: savedialog.php?status=saved');
    exit;
}
