<?php
// DB connection
$conn = new mysqli('localhost', 'gdhhsxmy_mlavallikkunnu', 'mlavallikkunnu', 'gdhhsxmy_mlavallikkunnu');

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

$id       = isset($_GET['id']) ? intval($_GET['id']) : 0;
$formData = [
    'full_name'        => '',
    'age'              => '',
    'gender'           => '',
    'school_name'      => '',
    'class_completed'  => '',
    'stream_interest'  => '',
    'attended_before'  => '',
    'parent_accompany' => '',
];
$subjectsSelected = [];
$careersSelected  = [];
$learningSelected = [];

// Edit mode: fetch existing data
if ($id > 0) {
    $res = $conn->query("SELECT * FROM survey_responses WHERE id = $id");

    if ($res && $res->num_rows > 0) {
        $formData = $res->fetch_assoc();
        $subRes   = $conn->query("SELECT subject_name FROM survey_subjects WHERE response_id = $id");
        while ($row = $subRes->fetch_assoc()) {
            $subjectsSelected[] = $row['subject_name'];
        }
        $carRes = $conn->query("SELECT career_name FROM survey_careers WHERE response_id = $id");
        while ($row = $carRes->fetch_assoc()) {
            $careersSelected[] = $row['career_name'];
        }
        $learnRes = $conn->query("SELECT learning_item FROM survey_learning WHERE response_id = $id");
        while ($row = $learnRes->fetch_assoc()) {
            $learningSelected[] = $row['learning_item'];
        }
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="manifest" href="/site.webmanifest">
<title><?php echo $id > 0 ? 'Edit - ' : ''; ?>Career Guidance Registration</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color: #fff; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; }
.form-section { background: #fff; border-radius: 10px; padding: 20px; margin-bottom: 25px; border: 1px solid #f1c40f; box-shadow: 0 4px 10px rgba(0,0,0,0.05); }
.form-section.border-danger { border: 2px solid red !important; }
.section-title { font-size: 1.3rem; font-weight: 600; border-left: 4px solid #f1c40f; padding-left: 10px; margin-bottom: 15px; color: #000; }
.required-symbol { color: red; font-weight: bold; margin-left: 4px; }
.form-control:focus, .form-select:focus { border-color: #f1c40f; box-shadow: 0 0 5px #f1c40f; }
.btn-gold { background-color: #f1c40f; color: #000; font-weight: bold; border: none; }
.btn-gold:hover { background-color: #d4ac0d; }
</style>
</head>
<body>
<div class="container my-5">
<h1 class="text-center mb-4"><?php echo $id > 0 ? 'Edit Your Response' : 'Career Guidance Event – Registration'; ?></h1>
<form method="POST" action="save.php" onsubmit="return validateForm()">
<input type="hidden" name="id" value="<?php echo $id; ?>">

<!-- Section 1 -->
<div class="form-section">
<div class="section-title">📋 Section 1: Personal Information <span class="required-symbol">*</span></div>
<div class="mb-3">
<label class="form-label">Full Name</label>
<input type="text" class="form-control" name="full_name" value="<?php echo htmlspecialchars($formData['full_name']); ?>">
</div>
<div class="mb-3">
<label class="form-label">Age</label>
<input type="number" class="form-control" name="age" min="1" max="99" maxlength="2"
oninput="if(this.value.length>2)this.value=this.value.slice(0,2);"
value="<?php echo htmlspecialchars($formData['age']); ?>">
</div>
<div class="mb-3">
<label class="form-label">Gender</label>
<select class="form-select" name="gender">
<option value="">-- Select Gender --</option>
<?php foreach (['Male','Female','Other'] as $g) {
    $sel = ($formData['gender'] == $g) ? 'selected' : '';
    echo "<option value='$g' $sel>$g</option>";
} ?>
</select>
</div>
<div class="mb-3">
<label class="form-label">School Name</label>
<input type="text" class="form-control" name="school_name" value="<?php echo htmlspecialchars($formData['school_name']); ?>">
</div>
<div class="mb-3">
<label class="form-label">Class Completed</label>
<?php foreach (['10th','Plus Two'] as $class) {
    $chk = ($formData['class_completed'] == $class) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='radio' name='class_completed' value='$class' $chk>
<label class='form-check-label'>$class</label></div>";
} ?>
</div>
</div>

<!-- Section 2 -->
<div class="form-section">
<div class="section-title">📚 Section 2: Academic Interests <span class="required-symbol">*</span></div>
<div class="mb-3">
<label class="form-label">Stream of Interest</label>
<?php foreach (['Science','Commerce','Arts/Humanities','Not sure yet'] as $stream) {
    $chk = ($formData['stream_interest'] == $stream) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='radio' name='stream' value='$stream' $chk>
<label class='form-check-label'>$stream</label></div>";
} ?>
</div>
<div class="mb-3">
<label class="form-label">Subjects You Enjoy (up to 3)</label>
<?php
$list = ['Mathematics','Physics','Chemistry','Biology','Computer Science','Economics','Business Studies','History','Political Science','Literature','Art'];

foreach ($list as $sub) {
    $chk = in_array($sub, $subjectsSelected) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input subject-checkbox' type='checkbox' name='subjects[]' value='$sub' $chk>
<label class='form-check-label'>$sub</label></div>";
}
$otherSub = '';

foreach ($subjectsSelected as $s) {
    if (!in_array($s, $list)) {
        $otherSub = $s;
    }
}
?>
<input type="text" class="form-control mt-2 subject-other" name="subjects[]" placeholder="Other" value="<?php echo htmlspecialchars($otherSub); ?>">
</div>
</div>

<!-- Section 3 -->
<div class="form-section">
<div class="section-title">🎯 Section 3: Career Aspirations <span class="required-symbol">*</span></div>
<div class="mb-3">
<label class="form-label">Career(s) of Interest</label>
<?php
$careerList = ['Health care','Engineering','Law','Social Work/Social Sciences','Environment Science','Business/Finance','Media/Journalism','Researcher','AI/Data Scientist','Teacher/Professor','Civil Services','Entrepreneur','Artist/Designer'];

foreach ($careerList as $car) {
    $chk = in_array($car, $careersSelected) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='checkbox' name='career[]' value='$car' $chk>
<label class='form-check-label'>$car</label></div>";
}
$otherCar = '';

foreach ($careersSelected as $c) {
    if (!in_array($c, $careerList)) {
        $otherCar = $c;
    }
}
?>
<input type="text" class="form-control mt-2 career-other" name="career[]" placeholder="Other" value="<?php echo htmlspecialchars($otherCar); ?>">
</div>
<div class="mb-3">
<label class="form-label">What would you like to learn from this event?</label>
<?php
$learnList = ['Information about different career paths','Guidance on choosing the right stream','Interaction with professionals','Scholarship and entrance exam details','Motivation and confidence building'];

foreach ($learnList as $item) {
    $chk = in_array($item, $learningSelected) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='checkbox' name='learn[]' value='$item' $chk>
<label class='form-check-label'>$item</label></div>";
}
$otherLearn = '';

foreach ($learningSelected as $l) {
    if (!in_array($l, $learnList)) {
        $otherLearn = $l;
    }
}
?>
<input type="text" class="form-control mt-2 learn-other" name="learn[]" placeholder="Other" value="<?php echo htmlspecialchars($otherLearn); ?>">
</div>
<div class="mb-3">
<label class="form-label">Have you attended any career guidance sessions before?</label>
<?php foreach (['Yes','No'] as $val) {
    $chk = ($formData['attended_before'] == $val) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='radio' name='attended' value='$val' $chk>
<label class='form-check-label'>$val</label></div>";
} ?>
</div>
<div class="mb-3">
<label class="form-label">Will your parent/guardian accompany you?</label>
<?php foreach (['Yes','No','Not sure'] as $val) {
    $chk = ($formData['parent_accompany'] == $val) ? 'checked' : '';
    echo "<div class='form-check'><input class='form-check-input' type='radio' name='parent_accompany' value='$val' $chk>
<label class='form-check-label'>$val</label></div>";
} ?>
</div>
</div>

<button type="submit" class="btn btn-gold btn-lg w-100"><?php echo $id > 0 ? 'Update' : 'Submit'; ?></button>
</form>
</div>

<script>
function validateForm() {
    let valid = true;
    let errors = [];

    // Reset previous errors
    document.querySelectorAll('.error-message').forEach(e => e.remove());
    document.querySelectorAll('.form-section').forEach(sec => sec.classList.remove('border-danger'));

    function addError(sectionTitle, message) {
        if (!errors.some(e => e.section == sectionTitle)) { // only first error per section
            errors.push({ section: sectionTitle, message });
        }
    }

    // Validation in exact HTML order
    if (!document.querySelector('input[name="full_name"]').value.trim())
        addError('Section 1', 'Enter your full name.');

    let age = document.querySelector('input[name="age"]').value.trim();
    if (!age || isNaN(age) || age < 1 || age > 99)
        addError('Section 1', 'Enter valid age (1-99).');

    if (!document.querySelector('select[name="gender"]').value)
        addError('Section 1', 'Select your gender.');

    if (!document.querySelector('input[name="school_name"]').value.trim())
        addError('Section 1', 'Enter your school name.');

    if (!document.querySelector('input[name="class_completed"]:checked'))
        addError('Section 1', 'Select completed class.');

    if (!document.querySelector('input[name="stream"]:checked'))
        addError('Section 2', 'Select your stream.');

    let subCount = document.querySelectorAll('.subject-checkbox:checked').length;
    let subOther = document.querySelector('.subject-other').value.trim();
    if (subCount == 0 && subOther == "")
        addError('Section 2', 'Select at least one subject.');
    if (subCount > 3)
        addError('Section 2', 'Max 3 subjects allowed.');

    let carCount = document.querySelectorAll('input[name="career[]"]:checked').length;
    let carOther = document.querySelector('.career-other').value.trim();
    if (carCount == 0 && carOther == "")
        addError('Section 3', 'Select at least one career.');

    let learnCount = document.querySelectorAll('input[name="learn[]"]:checked').length;
    let learnOther = document.querySelector('.learn-other').value.trim();
    if (learnCount == 0 && learnOther == "")
        addError('Section 3', 'Select at least one learning item.');

    if (!document.querySelector('input[name="attended"]:checked'))
        addError('Section 3', 'Answer if attended before.');

    if (!document.querySelector('input[name="parent_accompany"]:checked'))
        addError('Section 3', 'Answer about parent/guardian.');

    // Show errors in the order we collected them
    errors.forEach(err => {
        let section = [...document.querySelectorAll('.form-section')]
            .find(s => s.querySelector('.section-title').textContent.includes(err.section));
        if (section) {
            section.classList.add('border-danger');
            let e = document.createElement('div');
            e.className = 'error-message text-danger fw-bold mt-1';
            e.textContent = err.message;
            section.querySelector('.section-title').after(e);
        }
    });

    if (errors.length > 0) valid = false;
    return valid;
}

const cbs=document.querySelectorAll(".subject-checkbox");
cbs.forEach(cb=>cb.addEventListener("change",()=>{const cnt=document.querySelectorAll(".subject-checkbox:checked").length;
const other=document.querySelector(".subject-other");
if(cnt>=3){cbs.forEach(b=>{if(!b.checked)b.disabled=true;});if(!other.value.trim())other.disabled=true;}
else{cbs.forEach(b=>b.disabled=false);other.disabled=false;}}));
</script>
</body>
</html>
