<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
   <link rel="icon" href="download.jpeg">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap" rel="stylesheet">

    <title>Vengara Toppers Meet</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .photo-container {
            position: relative;
            display: inline-block;
            width: 45px;
            height: 45px;
        }
        .photo-container img {
            width: 100%;
            height: 100%;
        }
        .icon {
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            display: none;
            color: white;
            font-size: 24px;
        }
        .photo-container:hover .icon {
            display: block;
        }
    </style>
</head>
<body>
<?php
$con = new mysqli('localhost', 'gdhhsxmy_mlavengara', 'mlavengaramlavengara', 'gdhhsxmy_mlavengara');

if ($con->connect_error) {
    die('Connection failed: ' . $con->connect_error);
}
$sql      = 'SELECT students.*, panchayath.panchayath, ward.ward FROM students INNER JOIN panchayath ON students.panchayath = panchayath.id INNER JOIN ward ON students.ward = ward.id order by students.id desc ';
$result   = $con->query($sql);
$numRows  = $result->num_rows;
$students = [];
while ($row = $result->fetch_assoc()) {
    $students[] = $row;
}
$con->close();
?>
<div class="container mt-4">
    <h1 class="text-center">
    REGISTERED STUDENTS (<span id="studentCount">0</span>)
</h1>

    <div class="d-flex justify-content-center gap-2 flex-wrap my-3">
        <input type="text" id="searchInput" class="form-control" placeholder="Search..." style="max-width: 300px;">
        <select id="panchayathFilter" class="form-select" style="width: 200px;"><option value="">All Panchayaths</option></select>
        <select id="wardFilter" class="form-select" style="width: 200px;"><option value="">All Wards</option></select>
        <button id="exportBtn" class="btn btn-primary" onclick="exportToExcel()">Export to Excel</button>

    </div>
    <div class="table-responsive">
       <table class="table table-bordered table-sm align-middle text-center" id="studentsTable">

          <thead>
  <tr>
    <th style="width: 50px;">S.NO</th>
    <th style="width: 120px;">REG ID</th>
    <th style="width: 80px;">EXAM</th>
    <th style="width: 100px;">REG NO</th>
    <th style="width: 150px;">NAME</th>
    <th>ADDRESS</th>
    <th style="width: 110px;">PHONE</th>
    <th style="width: 130px;">PANCHAYATH</th>
    <th style="width: 100px;">WARD</th>
    <th style="width: 150px;">SCHOOL</th>
    <th style="width: 60px;">PHOTO</th>
    <th style="width: 80px;">MARKLIST</th>
   <!-- <th style="width: 60px;">EDIT</th>-->
  </tr>
</thead>

            <tbody id="tableBody"></tbody>
        </table>
    </div>
    <div class="d-flex justify-content-center mt-3 flex-wrap gap-2" id="paginationControls"></div>
</div>

<script>
const students = <?php echo json_encode($students); ?>;
let currentPage = 1;
const rowsPerPage = 10;
let filteredData = students.slice();

function renderTable() {
    const tbody = document.getElementById("tableBody");
    tbody.innerHTML = "";
    const start = (currentPage - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    const pageData = filteredData.slice(start, end);

    if (pageData.length == 0) {
        tbody.innerHTML = '<tr><td colspan="13" class="text-center">No data available</td></tr>';
        return;
    }

    pageData.forEach((row, index) => {
        const tr = document.createElement("tr");
        tr.innerHTML = `
            <td>${start + index + 1}</td>
            <td>${row.registrationid}</td>
            <td>${row.exam}</td>
            <td>${row.regnumber}</td>
            <td>${row.name}</td>
            <td>${row.address}</td>
            <td>${row.number}</td>
            <td>${row.panchayath}</td>
            <td>${row.ward}</td>
            <td>${row.school}</td>
            <td>
                ${row.photo ? `<img src="${row.photo}" width="45" height="45">` : '<i class="fa fa-user" style="font-size:45px;"></i>'}
            </td>
            <td>
                ${row.marklist ? `<a href="${row.marklist}" class="btn btn-danger btn-sm"><i class="fa fa-eye"></i></a>` : ''}
            </td>
         <!--   <td>
              //  <form action="edit.php" method="GET">
                  //  <input type="hidden" name="id" value="${row.id}">
                  //  <button class="btn btn-primary btn-sm"><i class="fa fa-pen"></i></button>
                </form>
            </td> -->
        `;
        tbody.appendChild(tr);
    });
    renderPagination();
}

function renderPagination() {
    const totalPages = Math.ceil(filteredData.length / rowsPerPage);
    const container = document.getElementById("paginationControls");
    container.innerHTML = "";

    if (currentPage > 1) {
        const prev = document.createElement("button");
        prev.textContent = "Previous";
        prev.className = "btn btn-outline-primary btn-sm";
        prev.onclick = () => { currentPage--; renderTable(); };
        container.appendChild(prev);
    }

    for (let i = 1; i <= totalPages; i++) {
        const btn = document.createElement("button");
        btn.textContent = i;
        btn.className = `btn btn-sm ${i == currentPage ? 'btn-primary' : 'btn-outline-primary'}`;
        btn.onclick = () => { currentPage = i; renderTable(); };
        container.appendChild(btn);
    }

    if (currentPage < totalPages) {
        const next = document.createElement("button");
        next.textContent = "Next";
        next.className = "btn btn-outline-primary btn-sm";
        next.onclick = () => { currentPage++; renderTable(); };
        container.appendChild(next);
    }
}

function applyFilters() {
    const text = document.getElementById("searchInput").value.toLowerCase();
    const panchayath = document.getElementById("panchayathFilter").value.toLowerCase();
    const ward = document.getElementById("wardFilter").value.toLowerCase();

    filteredData = students.filter(s => {
        const matchText = Object.values(s).some(val => (val + "").toLowerCase().includes(text));
        const matchPanchayath = !panchayath || s.panchayath.toLowerCase() == panchayath;
        const matchWard = !ward || s.ward.toLowerCase() == ward;
        return matchText && matchPanchayath && matchWard;
    });

    currentPage = 1;
    renderTable();
}

document.getElementById("searchInput").addEventListener("input", applyFilters);
document.getElementById("panchayathFilter").addEventListener("change", applyFilters);
document.getElementById("wardFilter").addEventListener("change", applyFilters);

window.onload = () => {
    const panchayathSelect = document.getElementById("panchayathFilter");
    const wardSelect = document.getElementById("wardFilter");
    const pSet = new Set(), wSet = new Set();
    students.forEach(s => { pSet.add(s.panchayath); wSet.add(s.ward); });
    [...pSet].sort().forEach(p => panchayathSelect.innerHTML += `<option value="${p}">${p}</option>`);
    [...wSet].sort().forEach(w => wardSelect.innerHTML += `<option value="${w}">${w}</option>`);
    renderTable();
    document.getElementById("studentCount").textContent = students.length;
};

</script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.0/xlsx.full.min.js"></script>


<script>

function exportToExcel() {
    const headers = [
        "S.NO", "REGISTRATION ID", "EXAM", "REGNUMBER", "NAME",
        "ADDRESS", "PHONE NO.", "PANCHAYATH", "WARD", "SCHOOL"
    ];

    // Build rows from filteredData (not just current page)
    const rows = filteredData.map((row, index) => [
        index + 1,
        row.registrationid,
        row.exam,
        row.regnumber,
        row.name,
        row.address,
        row.number,
        row.panchayath,
        row.ward,
        row.school
    ]);

    if (rows.length == 0) {
        alert("No data to export.");
        return;
    }

    const worksheet = XLSX.utils.aoa_to_sheet([headers, ...rows]);
    const workbook = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(workbook, worksheet, "Students");

    XLSX.writeFile(workbook, "students_data.xlsx");
}



</script>




</body>
</html>
