<?php
$recordsPerPage = 1000;
$page           = isset($_GET['page']) ? intval($_GET['page']) : 1;
$offset         = ($page - 1) * $recordsPerPage;

$con = new mysqli('localhost', 'gdhhsxmy_mlavengara', 'mlavengaramlavengara', 'gdhhsxmy_mlavengara');

if ($con->connect_error) {
    die('Connection failed: ' . $con->connect_error);
}

$totalRecords = $con->query('SELECT COUNT(*) AS total FROM students')->fetch_assoc()['total'];
$totalPages   = ceil($totalRecords / $recordsPerPage);

$sql = "SELECT students.*, panchayath.panchayath, ward.ward 
        FROM students 
        INNER JOIN panchayath ON students.panchayath = panchayath.id 
        INNER JOIN ward ON students.ward = ward.id
        LIMIT $recordsPerPage OFFSET $offset";

$result = $con->query($sql);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <title>Vengara Toppers Meet</title>
    <link rel="icon" href="download.jpeg" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link href="https://fonts.googleapis.com/css2?family=M+PLUS+Rounded+1c&display=swap" rel="stylesheet" />

    <style>
        @font-face {
            font-family: 'Mullet';
            src: url('font/transfonter.org-20240610-122131/MullerBold.ttf') format('truetype');
            font-weight: 700;
        }

        * {
            box-sizing: border-box;
        }

        html, body {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }

        .page {
            position: relative;
            width: 11in;
            height: 9in;
            margin: auto;
            overflow: hidden;
            background-color: white;
            page-break-after: always;
        }

        .piece {
            width: 38.2%;
            height: 80.7%;
            position: absolute;
            top: 10.2%;
            left: 7.8%;
        }

        .piece img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }

        .name {
            position: absolute;
            top: 43.8%;
            left: 50.62%; /* 10% inside the photo */
            max-width: 38.2%;
            font-family: 'Mullet', sans-serif;
            font-weight: 700;
            font-size: 25px;
            color: #2A2658;
            line-height: 1.2;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
        }

        img.bg {
            width: 100%;
            height: 100%;
            display: block;
        }

        .print-btn {
            padding: 10px 20px;
            background: #4CAF50;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
        }

        .button-container {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 20px 0;
        }

        @media print {
    @page {
        size: 11in 9in;
        margin: 0;
    }

    body {
        margin: 0;
        padding: 0;
    }

    .print-btn,
    .button-container {
        display: none;
    }

    .page {
        page-break-after: always;
        width: 11in;
        height: 9in;
    }
}

    </style>
</head>
<body>

<div class="button-container">
    <button class="print-btn" onclick="window.print()">Print Certificates</button>
</div>

<?php if ($result->num_rows > 0): ?>
    <?php while ($row = $result->fetch_assoc()): ?>
        <div class="page">
            <div class="piece">
                <img src="<?= htmlspecialchars($row['photo'] ?: 'Gratuate avatar.avif') ?>" alt="<?= htmlspecialchars($row['name']) ?>" />
            </div>
            <div class="name"><?= htmlspecialchars($row['name']) ?></div>
            <img class="bg" src="<?= $row['exam'] == 'SSLC' ? 'sslc.jpg' : 'plus2.jpg' ?>" />
        </div>
    <?php endwhile; ?>
<?php else: ?>
    <p>No records found.</p>
<?php endif; ?>

</body>
</html>
