<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <link rel="icon" href="download.jpeg">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Vengara Toppers Meet</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: #000;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      flex-direction: column;
      color: white;
      font-family: Arial, sans-serif;
      position: relative;
      background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('2ba38b31-5431-47c8-aac2-ba4b5e2bb0e6.jpeg') no-repeat center center fixed;
      background-size: cover;
    }

    #loaderContainer {
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .loader {
      width: 60px;
      height: 60px;
      border: 6px solid transparent;
      border-top: 6px solid #f44336;
      border-right: 6px solid #2196f3;
      border-bottom: 6px solid #4caf50;
      border-left: 6px solid #ffeb3b;
      border-radius: 50%;
      animation: spin 1.2s linear infinite;
      margin-bottom: 15px;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    #loadingText {
      font-size: 1.2rem;
      text-align: center;
    }

   #imageContainer {
  width: 100%;
  height: 100vh;
  display: none;
  box-sizing: border-box;
  padding-left: 10px; /* 👈 Adds left padding */
  display: flex;
  align-items: stretch;
  justify-content: flex-start;
}

#splashImage {
  height: 100vh;       /* Full height */
  width: auto;
  max-width: none;
  object-fit: contain;
  display: block;
}


  </style>
</head>
<body>

  <div id="loaderContainer">
    <div class="loader"></div>
    <div id="loadingText">Loading...</div>
  </div>

  <div id="imageContainer">
    <img id="splashImage" src="posterfront.jpg" alt="Toppers Meet Poster" />
  </div>

  <script>
    const img = document.getElementById('splashImage');
    const loaderContainer = document.getElementById('loaderContainer');
    const imageContainer = document.getElementById('imageContainer');

    img.onload = function () {
      loaderContainer.style.display = 'none';
      imageContainer.style.display = 'block';

      // Redirect after 5 minutes (300,000 ms)
      setTimeout(function () {
        window.location.href = "instructions.php";
      }, 5000);
    };

    img.onerror = function () {
      document.getElementById('loadingText').innerText = "Failed to load image.";
      // Optional fallback after 5 min
      setTimeout(function () {
        window.location.href = "instructions.php";
      }, 5000);
    };
  </script>
</body>
</html>
