<?php
// Define how many records per page
$recordsPerPage = 40;

// Get the current page number, default to 1 if not set
$page = isset($_GET['page']) ? intval($_GET['page']) : 1;

// Calculate the offset
$offset = ($page - 1) * $recordsPerPage;

// Your database connection code
$con = new mysqli('localhost', 'gdhhsxmy_kpamajeedmla', 'kpamajeedmla', 'gdhhsxmy_kpamajeedmla');

if ($con->connect_error) {
    die('Connection failed: ' . $con->connect_error);
}

// Count total records in the table
$totalRecordsQuery  = 'SELECT COUNT(*) AS total FROM students';
$totalRecordsResult = $con->query($totalRecordsQuery);
$totalRecords       = $totalRecordsResult->fetch_assoc()['total'];

// Calculate total pages
$totalPages = ceil($totalRecords / $recordsPerPage);

// SQL query with pagination
$sql = "SELECT students.*, panchayath.panchayath, ward.ward 
        FROM students 
        INNER JOIN panchayath ON students.panchayath = panchayath.id 
        INNER JOIN ward ON students.ward = ward.id
        LIMIT $recordsPerPage OFFSET $offset";

$result = $con->query($sql);



?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Print Certificates</title>
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=M+PLUS+Rounded+1c&display=swap" rel="stylesheet">
    <style>
        @font-face {
            font-family: 'Mullet';
            src: url('font/transfonter.org-20240610-122131/MullerLight.ttf') format('truetype');
            font-weight: 300;
            font-style: normal;
        }

        @font-face {
            font-family: 'Mullet';
            src: url('font/transfonter.org-20240610-122131/MullerRegular.ttf') format('truetype');
            font-weight: 400;
          
        }

        @font-face {
            font-family: 'Mullet';
            src: url('font/transfonter.org-20240610-122131/MullerMedium.ttf') format('truetype');
            font-weight: 500;
            
        }

        @font-face {
            font-family: 'Mullet';
            src: url('font/transfonter.org-20240610-122131/MullerBold.ttf') format('truetype');
            font-weight: 700;
            
        }



        body,
        html {
            margin: 0;
            padding: 0;
            width: 100%;
            height: 100%;
        }

        .container {
            position: relative;
            width: 100%;

            /* Set each container to take the full height of the viewport */
            max-width: 100%;
            display: block;
            page-break-after: always;
            /* Ensure each container starts on a new page */
            margin: 0;
            padding: 0;
        }

        .piece {
            width: 16%;
            height: 26%;
            aspect-ratio: 1;
            background-image: url('Gratuate avatar.avif');
            background-size: cover;
            position: absolute;
            top: 55.5%;
            left: 79%;
            transform: translate(-50%, -50%);
            /* border-radius: 50%; */
        }

        .para-division p {
            font-size: 1.4vw;
            position: absolute;
            top: 65%;
            left: 44.1%;
            width: 40%;
            transform: translate(-50%, -50%);
            display: flex;
            text-align: center;
            font-family: mullet, sans-serif;
            color: #535353;
            font-weight: 500;
           line-height: 2vw;
        }

        .piece img {
            width: 100%;
            height: 100%;
        }

        .print-btn {
            border-radius: 10px;
            box-shadow: -2px 6px 92px -22px rgba(0, 0, 0, 0.75);
            margin: 20px;
            width: 15%;
            padding: 5px 15px;
            /* Adjust padding as needed */
            box-sizing: border-box;
            /* Include padding in width calculation */
            background-color: #4CAF50;
            /* Green */
            border: none;
            color: white;
            text-align: center;
            text-decoration: none;
            display: inline-block;

            /* Adjust as needed */
            /* margin: 0; */
            /* Set margin to none */
            cursor: pointer;
        }

        .counter-num {
            width: 54px;
            height: 49px;
            /* background-position: center; */
            position: absolute;
            top: 84%;
            left: 82%;
            font-size: 13vw;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            font-weight: bold;
            margin: 0;
        }

        .register-num {
            width: 25%;
            height: 9%;
            background-position: center;
            position: absolute;
            top: 90.5%;
            left: 45%;
            font-size: 1.5vw;
            color: #2A2658;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            font-weight: bold;
            margin: 0;
        }

        .name {
            width: 90%;
            height: 10%;
            background-position: center;
            position: absolute;
            top: 82%;
            left: 6%;
            font-family: mullet, sans-serif;
            font-size: 2vw;
            background-position: center;
            position: absolute;
            top: 53%;
            left: 0%;
            font-family: mullet, sans-serif;
            font-size: 2.8vw;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
            text-align: center;
            font-weight: 800;
            color: #2A2658;
            margin: 0;
        }

        .namepanchayath {
            align-items: center;
            margin: 0;
        }

        img {
            width: 100%;
            height: auto;
            max-width: 100%;
            display: block;
            margin: 0;
        }

        .pagination {
            margin-top: 20px;
        }

        .pagination a {
            display: inline-block;
            padding: 5px 10px;
            margin-right: 5px;
            background-color: #f4f4f4;
            color: #333;
            border: 1px solid #ccc;
            text-decoration: none;
            margin-bottom: 7px;
        }

        .pagination a.active {
            background-color: #007bff;
            color: #fff;
        }

        .pagination a:hover {
            background-color: #ddd;
        }

        @media print {
            @page {
                size: landscape !important;
                size: auto;
                /* auto is the default value */
                margin: 0;
                /* this will remove the printer default margins */
            }

            body,
            html {
                margin: 0;
                padding: 0;
            }

            .container {
                margin: 0;
                padding: 0;
                width: 100vw;
                /* Full width of the viewport */
                height: 100vh;
                /* Full height of the viewport */
                max-width: 100%;
                display: block;
                page-break-after: always;
                box-sizing: border-box;
            }

            .print-btn {
                display: none;
            }

            .pagination {
                display: none;
            }

            .no-print {
                display: none;
            }
        }

        .d-flex {
            display: flex;
        }
    </style>
</head>

<body>



    <div class="d-flex">
        <?php echo "<div class='pagination'>";
for ($i = 1; $i <= $totalPages; $i++) {
    echo "<a class='no-print " . ($page == $i ? 'active' : '') . "' href='?page=$i'>$i</a>";
}
echo '</div>'; ?>
        <button id="print-btn" class="print-btn" onclick="printCertificates()">Print Certificates</button>

    </div>
    <?php


    if ($result->num_rows > 0) {
        $counter = 0; // Initialize a counter to keep track of entries
        while ($row = $result->fetch_assoc()) :
            $counter++; // Increment the counter for each entry
            ?>
            <div class="container">
                <div class="para-division">
                    <p>Heartly Congratulations on your well deserved Success in <?php echo htmlspecialchars($row['exam'], ENT_QUOTES, 'UTF-8'); ?> Examination 2023 - 24, Wish you as bright future as your present.</p>
                </div>
                <div class="piece">
                    <?php
                            if (!empty($row['photo'])) {
                                echo '<img src="' . htmlspecialchars($row['photo'], ENT_QUOTES, 'UTF-8') . '" />';
                            } else {
                                echo '<img src="Gratuate avatar.avif">';
                            }
            ?>
                </div>
                <div class="namepanchayath">
                    <div class="name" style="font-family: mullet, sans-serif;"><?php echo htmlspecialchars($row['name'], ENT_QUOTES, 'UTF-8'); ?></div>
                </div>
                <div class="register-num">
                    <?php
            $reg = str_pad($row['id'], 5, '0', STR_PAD_LEFT);
            echo htmlspecialchars($reg, ENT_QUOTES, 'UTF-8');
            ?>
                </div>
                <?php
                if ($counter % 4 == 1) {
                    // Show the specific image for the first entry in the group of four
                    echo '<img src="new skyfi new.png" alt="Ticket">';
                } else {
                    // Show the other image for the next three entries in the group of four
                    echo '<img src="uyare_2024_certificate_pink_new_SETTING.png" alt="Other Ticket">';
                }
            ?>
            </div>
    <?php
        endwhile;
    }
?>







    <script>
        // Function to print the content
        function printCertificates() {
            window.print();
        }
    </script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" />

</body>

</html>