<?php

session_start();


require('lib/dbclass.php');



require('PhpXlsxGenerator.php') ;


// Filter the excel data
function filterData(&$str)
{
    $str = preg_replace("/\t/", '\\t', $str);
    $str = preg_replace("/\r?\n/", '\\n', $str);

    if (strstr($str, '"')) {
        $str = '"' . str_replace('"', '""', $str) . '"';
    }
}

// Excel file name for download
$fileName = 'Student Details.xlsx';

// Column names
$excelData[] = [
    'Reg.No.',
    'Name',
    'Mobile',
    'Course',
    'Institute',
    'State',
    'District',
    'NEET Score',
    'Referral',
    'Payment',
    'Reference ID',
];

$course = [
    '0' => 'Select',
    1   => '12th student',
    '2' => '12th completed',
    '3' => 'Repeater',
    '4' => 'Rerepeater',
    '5' => 'Other',
];


if ($_SESSION['export']) {
    $whereClause = $_SESSION['export'];
} else {
    $whereClause = 'where tbl_candidates.id>0';
}


$_SESSION['export'] = '';




$data = findQuery("SELECT tbl_candidates.*,tbl_referal.name refername FROM tbl_candidates inner join tbl_referal on tbl_candidates.referal=tbl_referal.id  $whereClause ORDER BY tbl_candidates.id DESC");














if ($data) {
    // Output each row of the data
    foreach ($data as $index => $row) {
        $course_id_from_db = $row['course'];


        if (array_key_exists($course_id_from_db, $course)) {
            $courses = $course[$course_id_from_db];
        } else {
            $courses = '';
        }




        $lineData = [
            $row['Regno'],
            $row['name'],
            $row['mobile'],
            $courses,
              $row['school'],

              $row['state'],
                       $row['district'],
                        $row['neetscore'],
                        $row['refername'],
                        $row['paymentstatus'],

                         $row['paymentid'],

                        ];
        $excelData[] = $lineData;
    }
} else {
    $excelData .= 'No records found...' . "\n";
}




// Export data to excel and download as xlsx file
$xlsx = CodexWorld\PhpXlsxGenerator::fromArray($excelData);
$xlsx->downloadAs($fileName);

exit;
