// --------------sidebar toggling-----------------

const hamBurger = document.querySelector(".toggle-btn");

hamBurger.addEventListener("click", function () {
  document.querySelector("#sidebar").classList.toggle("expand");
});

//---------------------action button--------------------

document.addEventListener('DOMContentLoaded', function () {
    const dropdownIcons = document.querySelectorAll('.fa-ellipsis-vertical');

    dropdownIcons.forEach(icon => {
        icon.addEventListener('click', function (event) {
            const dropdownMenu = icon.nextElementSibling;
            const iconRect = icon.getBoundingClientRect();
            const menuHeight = dropdownMenu.offsetHeight;
            const menuWidth = dropdownMenu.offsetWidth;
            const windowHeight = window.innerHeight;
            const windowWidth = window.innerWidth;


            dropdownMenu.style.display = dropdownMenu.style.display === 'block' ? 'none' : 'block';


            dropdownMenu.style.top = `${iconRect.bottom}px`; 
            dropdownMenu.style.right = `${iconRect.left}px`; 
          
            if (iconRect.bottom + menuHeight > windowHeight) {
                dropdownMenu.style.top = `${iconRect.top - menuHeight}px`; 
            }

            if (iconRect.left + menuWidth > windowWidth) {
                dropdownMenu.style.left = `${windowWidth - menuWidth - 20}px`; 
            }

            document.querySelectorAll('.dropdown-menu').forEach(menu => {
                if (menu !== dropdownMenu) {
                    menu.style.display = 'none';
                }
            });


            event.stopPropagation();
        });
    });

    document.addEventListener('click', function () {
        document.querySelectorAll('.dropdown-menu').forEach(menu => {
            menu.style.display = 'none';
        });
    });
});

//-----------------------pagination-------------------------

const rowsPerPage = 8; 
let currentPage = 1;
const maxVisibleButtons = 5; 

const table = document.getElementById('Table');
const rows = table.querySelectorAll('tbody tr');
const totalRows = rows.length;
const totalPages = Math.ceil(totalRows / rowsPerPage);

const paginationButtons = document.getElementById('paginationButtons');
const prevPageButton = document.getElementById('prevPage');
const nextPageButton = document.getElementById('nextPage');

function displayRows(page) {
    const start = (page - 1) * rowsPerPage;
    const end = start + rowsPerPage;
    rows.forEach((row, index) => {
        row.style.display = (index >= start && index < end) ? '' : 'none';
    });
    updatePaginationButtons(); 
    updatePrevNextButtons(); 
}

function createPaginationButtons() {
    paginationButtons.innerHTML = '';
    const pageCount = Math.min(totalPages, maxVisibleButtons);
    const startButton = Math.max(1, currentPage - Math.floor(maxVisibleButtons / 2));
    const endButton = Math.min(startButton + maxVisibleButtons - 1, totalPages);

    for (let i = startButton; i <= endButton; i++) {
        const button = document.createElement('button');
        button.textContent = i;
        button.classList.add('pagination-button');
        button.addEventListener('click', () => {
            currentPage = i;
            displayRows(currentPage);
        });
        if (i === currentPage) {
            button.classList.add('selected');
        }
        paginationButtons.appendChild(button);
    }
}

function updatePaginationButtons() {
    if (totalRows > 0) {
        createPaginationButtons(); 
        updatePrevNextButtons(); 
    } else {
        paginationButtons.innerHTML = '';
        prevPageButton.style.display = 'none';
        nextPageButton.style.display = 'none';
    }
}

function updatePrevNextButtons() {
    prevPageButton.style.display = currentPage === 1 ? 'none' : '';
    nextPageButton.style.display = currentPage === totalPages ? 'none' : '';
}

prevPageButton.addEventListener('click', () => {
    if (currentPage > 1) {
        currentPage--;
        displayRows(currentPage);
    }
});

nextPageButton.addEventListener('click', () => {
    if (currentPage < totalPages) {
        currentPage++;
        displayRows(currentPage);
    }
});

displayRows(currentPage);
updatePaginationButtons();


// ------------------Modal Box--------------------

let rowToDelete;

document.querySelectorAll('.action-buttons-2, .action-buttons-7').forEach(button => {
    button.addEventListener('click', function() {
        rowToDelete = this.closest('tr');
        const modalElement = document.querySelector('#deleteModal .modal-content');
        modalElement.classList.remove('modal-slide-up');
        modalElement.classList.add('modal-slide-down');
        const deleteModal = new bootstrap.Modal(document.getElementById('deleteModal'));
        deleteModal.show();
    });
});

document.querySelector('.confirm-delete').addEventListener('click', function() {
    if (rowToDelete) {
        rowToDelete.remove();
    }

    const deleteModal = bootstrap.Modal.getInstance(document.getElementById('deleteModal'));
    deleteModal.hide();
});

document.querySelectorAll('[data-bs-dismiss="modal"]').forEach(button => {
    button.addEventListener('click', function() {
        closeModal(this.closest('.modal'));
    });
});


