<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <link rel="icon" href="ch centre_page-0001.jpg">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Care Club</title>
  <style>
  html, body {
    margin: 0;
    padding: 0;
    background-color: black;
    font-family: Arial, sans-serif;
    color: white;
    height: 100%;
  }

  .container {
    display: flex;
    flex-direction: column;
    height: var(--vh, 100vh);
  }

  main {
    flex: 1;
    display: flex;
    justify-content: center;
    align-items: center;
    background-color: black;
    overflow: hidden; /* only main area hidden overflow */
  }

  #loaderContainer,
  #imageContainer {
    display: flex;
    justify-content: center;
    align-items: center;
    width: 100%;
    height: 100%;
  }

  #imageContainer {
    display: none;
    opacity: 0;
    transition: opacity 0.8s ease-in-out;
  }

  #imageContainer.show {
    opacity: 1;
  }

  #splashImage {
    max-height: 80%;
    max-width: 90%;
    object-fit: contain;
  }

  .loader {
    width: 60px;
    height: 60px;
    border: 6px solid transparent;
    border-top: 6px solid #f44336;
    border-right: 6px solid #2196f3;
    border-bottom: 6px solid #4caf50;
    border-left: 6px solid #ffeb3b;
    border-radius: 50%;
    animation: spin 1.2s linear infinite;
    margin: auto;
  }

  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }

  #loadingText {
    font-size: 1.2rem;
    text-align: center;
    margin-top: 10px;
  }

  footer {
    padding: 15px;
    background-color: #f3f3fb;
    text-align: center;
    border-top: 1px solid #ccc;
    font-size: 16px;
    font-weight: bold;
  }

  footer span {
    background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    display: inline-block;
    margin-right: 10px;
  }

  footer img {
    height: 40px;
    vertical-align: middle;
  }
</style>

</head>
<body>

  <div class="container">
    <main>
      <div id="loaderContainer">
        <div style="text-align:center">
          <div class="loader"></div>
          <div id="loadingText">Loading...</div>
        </div>
      </div>

      <div id="imageContainer">
        <img id="splashImage" src="ch centre_page-0001.jpg" alt="Care Club Poster" />
      </div>
    </main>

    <footer>
      <span>Powered by</span>
      <a href="https://workmateinfotech.com" target="_blank">
        <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo">
      </a>
    </footer>
  </div>

  <script>
    // Fix mobile vh issue
    function setVh() {
      let vh = window.innerHeight * 0.01;
      document.documentElement.style.setProperty('--vh', `${vh * 100}px`);
    }
    window.addEventListener('resize', setVh);
    setVh();

    const img = document.getElementById('splashImage');
    const loaderContainer = document.getElementById('loaderContainer');
    const imageContainer = document.getElementById('imageContainer');

    img.onload = function () {
      loaderContainer.style.display = 'none';
      imageContainer.style.display = 'flex';
      setTimeout(() => imageContainer.classList.add('show'), 10);

      setTimeout(function () {
        window.location.href = "instructions.php";
      }, 2000);
    };

    img.onerror = function () {
      document.getElementById('loadingText').innerText = "Failed to load image.";
      setTimeout(function () {
        window.location.href = "instructions.php";
      }, 2000);
    };
  </script>

</body>
</html>
